<?php
  require("connzara.php"); 

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

	// Load table data from file
	public function LoadData($file) {
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line) {
			$data[] = explode(';', chop($line));
		}
		return $data;
	}

	// Colored table
	public function ColoredTable($header,$data) {
		// Colors, line width and bold font
		$this->SetFillColor(43, 53, 148);
		$this->SetTextColor(255);
		$this->SetDrawColor(128, 0, 0);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		// Header
		$w = array(30, 90, 35 );
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i) {
			$this->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
		}
		$this->Ln();
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data
		$fill = 0;
		foreach($data as $row) {
			$this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
			$this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
			$this->Cell($w[2], 6, number_format($row[2]), 'LR', 0, 'R', $fill);
			 
			$this->Ln();
			$fill=!$fill;
		}
		$this->Cell(array_sum($w), 0, '', 'T');
	}
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('TCPDF Example 011');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 011', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

// add a page
$pdf->AddPage();

$queryk=mysqli_query($con,'SELECT COMPANYNAME,PHYSICALADD,email,PHONE1,WEB   FROM companyinfo c;');
$rowa=mysqli_fetch_array($queryk); 
 
 $pdf->Cell(0,10,$rowa['COMPANYNAME'],'','','C'); 
  $pdf->Ln(5); 
 $pdf->Cell(0,10,$rowa['PHYSICALADD'].'  Tel '.$rowa['PHONE1'],'','','C'); 
  $pdf->Ln(5);  
 $pdf->Cell(0,10,$rowa['email'],'','','C'); 
  $pdf->Ln(5); 
 $pdf->Cell(0,10,$rowa['WEB'],'','','C'); 
 $pdf->Ln(5);
 $row=mysqli_fetch_array(mysqli_query($con," select concat(' Advance for ',PYear,'/',PMonth)Descr from payrollrun  where PYear='".$_SESSION['PYear']."' and Mn= '".$_SESSION['Pmnth']."'"));
  
 $pdf->Cell(40,10, $row['Descr']);  
 $pdf->Ln();  

$data=array();
// column titles
$header = array('Emp No',	'Employee Names ',    'Advance');
 $where=" where PRID =(select PRID  from payrollrun where PYear='".$_SESSION['PYear']."' and Mn= '".$_SESSION['Pmnth']."')  and   ADVANCETOTAL>0 "; 
	  $query= mysqli_query($con,"SELECT Id,(SELECT   EmpNo FROM employees a where a.EmpId=k.EmpId)EmpNo,(SELECT   concat( SurName,'   ',FirstName,' ',OtherNames) FROM employees a where a.EmpId=k.EmpId) EmpId,ADVANCETOTAL FROM  payrollrunpay k  $where  order by EmpNo/1");	 	
  		 echo mysqli_error($con);
		 $bal=0;
while($row= mysqli_fetch_array($query)) {  
	 
	 array_push($data,array($row['EmpNo'],$row['EmpId'],$row['ADVANCETOTAL']));
   } 

 
$pdf->ColoredTable($header, $data);
 $pdf->lastPage(); 
 $query=mysqli_query($con,"SELECT pdfnm FROM tblpdfs t;");
 while($row=mysqli_fetch_array($query)){
	 $filename = $row["pdfnm"].".pdf";
 
if (file_exists($filename)) {
     unlink($filename);
}
}
	 
	  mysqli_query($con,"delete from tblpdfs ;");
	  $query=mysqli_query($con,"SELECT date_format((select if(sysuse='T',Trdate,now()) state from systactive),'pdf_%H%i%S') nname FROM dual ;");
	  $row=mysqli_fetch_array($query); 
	  $nname=$_SERVER['SCRIPT_FILENAME'];
	    $base=basename($_SERVER['PHP_SELF']); 
		$nname=str_replace($base,'', $nname); 
	   $nname=$nname.'pdfs/'.$row['nname'];
	  mysqli_query($con,"insert into tblpdfs(pdfnm)values('".$nname."');"); 
     $pdf->Output($nname.".pdf","I");